<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage helpers
* @filesource
*/

#load_libraries('Error', 'Validator'); //autoloaded in this application, don't add the overhead of an attempted re-load


/**
* Checks against various zero-date formats to see if the given date has a value.
* @param string Date in a MYSQL format
* @return boolean
*/
if(!function_exists('mysql_date_is_empty')){
	function mysql_date_is_empty($mysql_date){
		if(empty($mysql_date)) return true; //empty string, boolean false, null, are all OK
		if(!validates_as('mysql_date', $mysql_date) && !validates_as('mysql_datetime', $mysql_date))
			 return should_be('a mysql date (YYYY-MM-DD) or a mysql datetime (YYYY-MM-DD HH:MM:SS)', $mysql_date);
		$possibilities = array('0', '0000-00-00', '0000-00-00 00:00:00');
		return (empty($mysql_date) || in_array($mysql_date, $possibilities));
	}
}


/** If we're outside of a normal Codeigniter instance, bring in the parent CI helper in case there are any dependencies */
if(defined('CODEIGNITER_SYSTEM_DIRECTORY')) require_once CODEIGNITER_SYSTEM_DIRECTORY.'helpers/date_helper.php';

/* End of file ICARUS_date_helper.php */